<?php
session_start();
require_once 'config/api_config.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="css/style.css">
    <!-- Add FontAwesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <div class="container">
        <!-- Sidebar -->
        <div class="sidebar">
            <!-- Logo -->
            <div class="logo">
                <img src="path/to/your/logo.png" alt="Logo">
            </div>

            <!-- Navigation -->
            <div class="nav-section">
                <h3>Dashboard</h3>
                <a href="index.php" class="nav-item active">
                    <i class="fas fa-home"></i>
                    Dashboard
                </a>
            </div>

            <div class="nav-section">
                <h3>SERVICES</h3>
                <a href="buy-usa-numbers.php" class="nav-item">
                    <i class="fas fa-phone"></i>
                    Buy USA Numbers
                </a>
                <a href="buy-all-numbers.php" class="nav-item">
                    <i class="fas fa-globe"></i>
                    Buy all countries Numbers
                </a>
                <a href="fund-wallet.php" class="nav-item">
                    <i class="fas fa-wallet"></i>
                    Fund Wallet
                </a>
                <a href="buy-social-media.php" class="nav-item">
                    <i class="fas fa-users"></i>
                    Buy Social Media Account
                </a>
            </div>

            <div class="nav-section">
                <h3>HISTORY</h3>
                <a href="numbers-history.php" class="nav-item">
                    <i class="fas fa-history"></i>
                    Numbers History
                </a>
                <a href="transaction-history.php" class="nav-item">
                    <i class="fas fa-exchange-alt"></i>
                    Transaction History
                </a>
            </div>

            <div class="nav-section">
                <h3>SUPPORTS</h3>
                <a href="contact.php" class="nav-item">
                    <i class="fas fa-envelope"></i>
                    Contact Us
                </a>
                <a href="join-channel.php" class="nav-item">
                    <i class="fas fa-users"></i>
                    Join Channel
                </a>
            </div>
        </div>

        <!-- Main Content -->
        <div class="main-content">
            <!-- Top Bar -->
            <div class="top-bar">
                <button class="toggle-sidebar">
                    <i class="fas fa-bars"></i>
                </button>
                <div class="right-elements">
                    <button class="theme-toggle">
                        <i class="fas fa-sun"></i>
                    </button>
                    <div class="balance">
                        <i class="fas fa-coins"></i>
                        0.00
                    </div>
                    <div class="user-profile">
                        <img src="path/to/profile-image.jpg" alt="Profile">
                    </div>
                </div>
            </div>

            <!-- Page Content -->
            <div class="content">
                <!-- Country Selection -->
                <div class="selection-area">
                    <div class="select-group">
                        <label>Select Country</label>
                        <select class="country-select">
                            <option value="US">United States</option>
                            <!-- Add more countries as needed -->
                        </select>
                    </div>
                    <div class="select-group">
                        <label>Select Service</label>
                        <select class="service-select">
                            <option value="">Select an option</option>
                            <!-- Add services as needed -->
                        </select>
                    </div>
                </div>

                <!-- No Active Numbers Display -->
                <div class="no-numbers">
                    <img src="path/to/empty-state-image.png" alt="No Active Numbers">
                    <p>No Active Numbers</p>
                </div>
            </div>
        </div>
    </div>

    <script src="js/script.js"></script>
</body>
</html>

