<?php
require '../config/db.php';
session_start();

// Ensure user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: ../auth/login.php");
    exit;
}

// Fetch user wallet balance
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$wallet_balance = $user['wallet_balance'];

// Fetch transaction history
$transactions = $pdo->prepare("SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC");
$transactions->execute([$user_id]);
$transactions = $transactions->fetchAll(PDO::FETCH_ASSOC);

// Handle Wallet Funding
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["amount"])) {
    $amount = floatval($_POST["amount"]);

    if ($amount > 0) {
        // Update wallet balance
        $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?")
            ->execute([$amount, $user_id]);

        // Add transaction record
        $pdo->prepare("INSERT INTO transactions (user_id, type, amount, status) VALUES (?, 'credit', ?, 'completed')")
            ->execute([$user_id, $amount]);

        $_SESSION['success'] = "Wallet funded successfully!";
        header("Location: wallet.php");
        exit;
    } else {
        $_SESSION['error'] = "Invalid amount!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Wallet - SMS Rental</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <h2 class="text-center">Wallet</h2>
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
        <?php endif; ?>

        <div class="card p-4 shadow-sm">
            <h4>Your Wallet Balance: <strong>$<?= number_format($wallet_balance, 2); ?></strong></h4>
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">Enter Amount:</label>
                    <input type="number" name="amount" class="form-control" min="1" required>
                </div>
                <button type="submit" class="btn btn-success w-100">Fund Wallet</button>
            </form>
        </div>

        <h4 class="mt-5">Transaction History</h4>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $tx): ?>
                    <tr>
                        <td><?= date("Y-m-d H:i", strtotime($tx['created_at'])); ?></td>
                        <td><?= ucfirst($tx['type']); ?></td>
                        <td>$<?= number_format($tx['amount'], 2); ?></td>
                        <td><?= ucfirst($tx['status']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
