<?php
require_once 'config/db.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    // User not logged in, redirect to login
    $_SESSION['error'] = "You need to log in to rent a number.";
    header("Location: login.php");
    exit;
}

// Get service and country from request
$service_id = $_GET['service_id'] ?? null;
$country = $_GET['country'] ?? null;

if (!$service_id || !$country) {
    $_SESSION['error'] = "Invalid request. Please select a service and country.";
    header("Location: index.php");
    exit;
}

// Fetch service details from API
$api_url = "https://api.smspool.net/request/service/details?service=$service_id";
$api_key = getenv('API_KEY');

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $api_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $api_key",
        "Content-Type: application/json"
    ],
]);

$response = curl_exec($curl);
curl_close($curl);
$service_details = json_decode($response, true);

if (!$service_details || !isset($service_details['response']['price'])) {
    $_SESSION['error'] = "Service not found.";
    header("Location: index.php");
    exit;
}

$price = $service_details['response']['price'];
$user_balance = $_SESSION['wallet_balance'];

// Check wallet balance
if ($user_balance < $price) {
    $_SESSION['error'] = "Insufficient balance. Please fund your wallet.";
    header("Location: wallet.php");
    exit;
}

// Show confirmation message
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Confirm Purchase</title>
    <link rel="stylesheet" href="public/style.css">
</head>
<body>
    <div class="container">
        <h2>Confirm Purchase</h2>
        <p>Service: <?= htmlspecialchars($service_details['response']['name']) ?></p>
        <p>Price: $<?= number_format($price, 2) ?></p>
        <p>Country: <?= strtoupper($country) ?></p>
        <p>Wallet Balance: $<?= number_format($user_balance, 2) ?></p>

        <form action="process_rent.php" method="POST">
            <input type="hidden" name="service_id" value="<?= $service_id ?>">
            <input type="hidden" name="country" value="<?= $country ?>">
            <input type="hidden" name="price" value="<?= $price ?>">
            <button type="submit" class="btn btn-success">Confirm Purchase</button>
            <a href="index.php" class="btn btn-danger">Cancel</a>
        </form>
    </div>
</body>
</html>
